/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.fcs.chatlet;

import com.ibm.hwmca.fw.fcs.chatlet.ChatletRequest;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

final class ChatletInitialRequest
extends ChatletRequest {
    String chatletClassName;

    ChatletInitialRequest(String chatletClassName) {
        if (chatletClassName == null) {
            throw new IllegalArgumentException("Intended chatlet class must not be null");
        }
        this.chatletClassName = chatletClassName;
        this.requestType = 0;
        this.requestSubType = 1;
    }

    ChatletInitialRequest() {
    }

    protected void writeToStream(ObjectOutputStream oos) throws IOException {
        super.writeToStream(oos);
        oos.writeUTF(this.chatletClassName);
    }

    void load(ObjectInputStream in) throws IOException {
        this.chatletClassName = in.readUTF();
    }

    String getChatletClassName() {
        return this.chatletClassName;
    }

    public String toString() {
        return "ChatletPacket[" + this.transactionId + "," + this.chatletId + "," + ChatletInitialRequest.typeToString(this.requestType) + "," + ChatletInitialRequest.subtypeToString(this.requestSubType) + "," + "'" + this.chatletClassName + "'," + Integer.toHexString(this.hashCode()) + "]";
    }
}

